#include "nxp_lpc11u6x.h"

#define DC1        (130)                                   // duty cycle 1
#define DC2        (135)                                   // duty cycle 2
#define hperiod    (180)

void SCT0_Init(void)
{
    LPC_SYSCON->PRESETCTRL    |= (1 << 9);                 // de-assert SCT0 reset

    LPC_SCT0->CONFIG          |= (1 << 17);                // split timers, auto limit
    LPC_SCT0->CTRL_L          |= (1 << 4);                 // configure SCT1 as BIDIR

    LPC_SCT0->MATCH[0].L       = hperiod;                  // match on (half) PWM period
    LPC_SCT0->MATCHREL[0].L    = hperiod;
    LPC_SCT0->MATCH[1].L       = DC1;                      // match on duty cycle 1
    LPC_SCT0->MATCHREL[1].L    = DC1;
    LPC_SCT0->MATCH[2].L       = DC2;                      // match on duty cycle 2
    LPC_SCT0->MATCHREL[2].L    = DC2;

    LPC_SCT0->EVENT[0].STATE   = 0xFFFFFFFF;               // event 0 happens in all states
    LPC_SCT0->EVENT[0].CTRL    = (2 << 10) | (2 << 12);    // IN_0 falling edge only condition

    LPC_SCT0->EVENT[1].STATE   = 0xFFFFFFFF;               // event 1 happens in all states
    LPC_SCT0->EVENT[1].CTRL    = (1 << 10) | (2 << 12);    // IN_0 rising edge only condition

    LPC_SCT0->EVENT[2].STATE   = 0xFFFFFFFF;               // event 2 happens in all states
    LPC_SCT0->EVENT[2].CTRL    = (1 << 0) | (1 << 12);     // match 1 (DC1) only condition

    LPC_SCT0->EVENT[3].STATE   = 0xFFFFFFFF;               // event 3 happens in all states
    LPC_SCT0->EVENT[3].CTRL    = (2 << 0) | (1 << 12);     // match 2 (DC2) only condition

    LPC_SCT0->OUT[0].SET       = (1 << 0) | (1 << 2);      // event 0 and 2 set OUT0 (blue LED)
    LPC_SCT0->OUT[0].CLR       = (1 << 2);                 // event 2 clears OUT0 (blue LED)
    LPC_SCT0->OUT[1].SET       = (1 << 3);                 // event 3 sets OUT1 (red LED)
    LPC_SCT0->OUT[1].CLR       = (1 << 0) | (1 << 3);      // event 0 and 3 clear OUT1 (red LED)
    LPC_SCT0->RES             |= 0x0000000F;               // toggle OUT0 and OUT1 on conflict
    LPC_SCT0->OUTPUT          |= 1;                        // default set OUT0 and and clear OUT1

    LPC_SCT0->STOP_L           = (1 << 0);                 // event 0 will stop the timer
    LPC_SCT0->EVEN             = (1 << 1);                 // event 1 will generate an irq

    NVIC_EnableIRQ(SCT0_1_IRQn);                           // enable SCT0/1 interrupt

	LPC_SCT0->CTRL_L          &= ~(1 << 2);                // start timer
}
